//+------------------------------------------------------------------+
//|                                                          ATR.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//|                                                                  |
//|            Originial MetaQuotes example file modified by PT 2010 |
//|          for demonstration of storing indicator values in a file |
//|                                                                  |
//|  Modifications for storing values are marked in source code with |
//|         comments of form // Modification { and // Modification } |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
//---- input parameters
extern int AtrPeriod=14;
// Modification {
extern string OutputBaseFilename="ATR";
// Modification }

//---- buffers
double AtrBuffer[];
double TempBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- 1 additional buffer used for counting.
   IndicatorBuffers(2);
//---- indicator line
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,AtrBuffer);
   SetIndexBuffer(1,TempBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="ATR("+AtrPeriod+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
//----
   SetIndexDrawBegin(0,AtrPeriod);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Average True Range                                               |
//+------------------------------------------------------------------+
int start()
  {
   int i,counted_bars=IndicatorCounted();
//----
   if(Bars<=AtrPeriod) return(0);
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<=AtrPeriod;i++) AtrBuffer[Bars-i]=0.0;
//----
   i=Bars-counted_bars-1;
   while(i>=0)
     {
      double high=High[i];
      double low =Low[i];
      if(i==Bars-1) TempBuffer[i]=high-low;
      else
        {
         double prevclose=Close[i+1];
         TempBuffer[i]=MathMax(high,prevclose)-MathMin(low,prevclose);
        }
      i--;
     }
//----
// Modification {
   string outputFilename = StringConcatenate(Symbol(), ".", formatPeriod(Period())
     , ".", OutputBaseFilename, "(", AtrPeriod, ").csv");
   int fileHandle = FileOpen(outputFilename, FILE_CSV | FILE_READ | FILE_WRITE);
// Modification }

   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   for(i=0; i<limit; i++)
// Modification {
   {
// Modification }
     AtrBuffer[i]=iMAOnArray(TempBuffer,Bars,AtrPeriod,0,MODE_SMA,i);
// Modification {
     FileWrite(fileHandle, TimeToStr(Time[i], TIME_DATE | TIME_SECONDS)
     , Open[i], High[i], Low[i], Close[i], AtrBuffer[i]);
   }

   FileClose(fileHandle);
// Modification }

//----
   return(0);
  }
//+------------------------------------------------------------------+

// Modification {
string formatPeriod(int minutes)
{ switch ( minutes)
  { case PERIOD_H1  : return("hourly");
    case PERIOD_H4  : return("4 hours");
    case PERIOD_D1  : return("daily");
    case PERIOD_W1  : return("weekly");
    case PERIOD_MN1 : return("monthly");
    default         : return(StringConcatenate(DoubleToStr(minutes, 0), " min"));
  }
}
// Modification }
